***************************************************************************************
* 02/10/2017
***************************************************************************************

      SUBROUTINE W_AMF_METHODS(METHOD,THETA,MU) 

	IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (NN=5)
      DIMENSION A(NN,NN),Q(NN,NN),C(NN),B(NN),HB(NN),RO(NN)
      REAL*8 MU
      
	COMMON /COEFFICIENTS/A,Q,C,B,HB,RO,IQ,ISTAGE
*---------------------------------------------
* INPUT 
*     METHOD: INTEGER THAT IDENTIFIES THE METHOD
* OUTPUT
*     THETA: DIAGONAL COEFFICIENT OF THE  W-METHOD
*     MU: PARAMETER FOR LINEAR REFINEMENT (TYPICALLY MU=THETA)
*   A,X,C,B,HB,RO,IQ,ISTAGE (IN COMMON) COEFFICIENTS OF THE PAIR (W-METHOD + EMBEDDED)
*      IQ: ORDER OF THE EMBBEDED METHOD
*      ISTAGE: NUMBER OF STAGES OF THE PAIR W-METHOD AND EMBEDDED ONE
*----------------------------------------------
* W-METHOD (A,Q,B,THETA) WITH S STAGES (S=ISTAGE) 
* A, Q strictly lower triangular matrices
* B vector of weighs, THETA is a constant.
* HB is the weigh vector for the embedded method
* RO=(I-Q)^{-1} e, e=(1,1,...,1) (the vectors are always column vectors)
* C=A*RO=(c_i)_{i=1}^s is the vector of nodes.
*************************************************************
* The time integration is carried out with 3 STAGE ROW-AMF METHODS (EXACT AMF).
*  AUTONOMOUS ODE SYSTEM:             Y'(T)=F(Y) 
*                          
****
* Do for i=1,2,...,S
*
* (I-THETA TAU W) K_i= TAU*F(y_n + \SUM_{j=1}^{i-1} A_{ij} K_j) + \SUM_{j=1}^{i-1} Q_{ij} K_j 
*  
* End Do
****
* W \approx F_y(y_n), THETA>0, TAU=t_{n+1}-t_n
*
* y_{n+1} = y_n + \SUM_{j=1}^S B_j K_j.
* embedded method: \hat{y}_{n+1} = y_n + \SUM_{j=1}^S HB_j K_j
*------------------------
* FOR ODEs NONAUTONOMOUS SYSTEMS:    u'(t)=f(t,u) 
* by making the change y=(t,u), F(y)=(1,f(t,u))
* and taking the exact Jacobian of the f_t(t_n,u_n) part, then the method should be
* 
* Do for i=1,2,...,S
*
* (I-THETA TAU W) K_i= TAU*f(t_n+c_i TAU, u_n + \SUM_{j=1}^{i-1} A_{ij} K_j) + 
*                       \SUM_{j=1}^{i-1} Q_{ij} K_j + RO_i THETA TAU^2 f_t(t_n,u_n)
*  
* End Do
****
* where R0=(R0_i)_{i=1}^s =(I-Q)^{-1} e, e=(1,1,...,1), W \approx f_u(t_n,u_n)
*
* u_{n+1} = u_n + \SUM_{j=1}^S B_j K_j.
* embedded method: \hat{u}_{n+1} = u_n + \SUM_{j=1}^S HB_j K_j 

* In some cases other forms of getting the NONAUTONOMOUS version have been
* used but the former is the standar one.
*--------------------------
*

      A=0
	Q=0
	C=0
	B=0
	HB=0
	RO=0

       IF (METHOD.EQ.0) THEN !1-STAGE W-METHOD
        ISTAGE=1 !NUMBER OF STAGES
        IQ=0 ! IS THE ORDER OF THE ROW EMBEDDED METHOD (NONE)
        THETA=0.5D0
        MU=THETA
        B(1)=1.D0
	RO(1)=1.D0
        
      ELSEIF (METHOD.EQ.1) THEN !W3A (Appl.Math.Comput. 2016, Order 3 has ROW)
	ISTAGE=3 !NUMBER OF STAGES
       IQ=2 ! IS THE ORDER OF THE ROW EMBEDDED METHOD

      RAT=DSQRT(3.D0)
	 THETA=0.4358665215084590D0
	 MU=THETA

	A(2,1)=1.D0
	A(3,1)=(4-RAT)/4
	A(3,2)=1.D0/4

	Q(2,1)=-3+RAT
	Q(3,1)=-3.D0/2
	Q(3,2)=-(3+RAT)/4

	C(1)=0
	C(2)=1.D0
	C(3)=1.D0/2

	B(1)=(10-RAT)/6
	B(2)=(4+RAT)/6
	B(3)=2.D0/3

	RO(1)=1.D0
	RO(2)=-2+RAT
	RO(3)=(1-RAT)/4.D0

	HB(2)= (1.D0-THETA)/(2-THETA*(3-RAT)) !EMBEDDED METHOD OF ORDER TWO
	HB(1)=1+ HB(2)*(2-RAT)
	HB(3)=0


      ELSEIF (METHOD.EQ.2) THEN !W3B (Appl.Math.Comput. 2016, Order 3 has ROW)

	ISTAGE=3 !NUMBER OF STAGES
       IQ=2

      RAT=DSQRT(3.D0)
	 THETA=0.4358665215084590D0

	A(2,1)=1.D0
	A(3,1)=(4+RAT)/4
	A(3,2)=1.D0/4

	Q(2,1)=-3-RAT
	Q(3,1)=-3.D0/2
	Q(3,2)=(-3+RAT)/4

	C(1)=0
	C(2)=1.D0
	C(3)=1.D0/2

	B(1)=(10+RAT)/6
	B(2)=(4-RAT)/6
	B(3)=2.D0/3

	RO(1)=1.D0
	RO(2)=-2-RAT
	RO(3)=(1+RAT)/4.D0

	HB(2)= (1.D0-THETA)/(2+THETA*Q(2,1)) !EMBEDDED METHOD OF ORDER TWO
	HB(1)=1-HB(2)*(1+Q(2,1))
	HB(3)=0

      HB=1.D0/50*HB + 49.D0/50*B !THE NEW ESTIMATE IS FOR BALANCE THE TOLERANCES WITH THE GLOBAL ERRORS

      ELSEIF (METHOD.EQ.3) THEN  !W3S (Appl.Math.Comput. 2016 and CEDYA 2015)
*(L-stable method for d=1. It only has order 2 has ROW method and W-method, but has optimized coefficients)

	ISTAGE=3 !NUMBER OF STAGES 
       IQ=1

      RAT=DSQRT(3.D0)

	 THETA=0.4358665215084590D0

	A(2,1)=1.D0/2
	A(3,1)=2-RAT
	A(3,2)=2.D0

	Q(2,1)=(-3+RAT)/2
	Q(3,1)=0
	Q(3,2)=-2*(3+RAT)

	C(1)=0
	C(2)=1.D0/2
	C(3)=1.D0

	B(1)=(7-2*RAT)/6
	B(2)=(5+RAT)/3
	B(3)=1.D0/6

	RO(1)=1.D0
	RO(2)=(-1+RAT)/2
	RO(3)=7+12.D0/(-3+RAT)

	HB(2)= (1.D0-THETA)/(2*A(2,1)+THETA*Q(2,1)) !EMBEDDED METHOD OF ORDER TWO
	HB(1)=1-HB(2)*(1+Q(2,1))
	HB(3)=0

      ELSEIF (METHOD.EQ.6) THEN !JCAM 2016 (NUMDIFF-2015)
* (STRONGLY A-STABLE 1d, A(0)-STABLE ANY d, ORDER 2 AS W-METHOD AND ORDER 3 AS ROW METHOD, STAGE-ORDER Prot-Rob=1) 
	ISTAGE=3 !NUMBER OF STAGES
       IQ=2 !EMBEDDED ROW METHOD OF ORDER TWO (ORDER ONE AS W-METHOD)

       RAT=DSQRT(3.D0)
	 THETA=0.5D0+RAT/3

	A(2,1)=1.D0
	A(3,1)=1-RAT/4
	A(3,2)=1.D0/4

	Q(2,1)=-3+RAT
	Q(3,1)=-3+RAT
	Q(3,2)=(-3+RAT)/4

	C(1)=0
	C(2)=1.D0
	C(3)=1.D0/2

	B(1)=(16-5*RAT)/6
	B(2)=(4-RAT)/6
	B(3)=2.D0/3

	RO(1)=1.D0
	RO(2)=-2+RAT
	RO(3)=(1-RAT)/4

	HB(1)=(16-11*RAT)/(8-6*RAT)
	HB(2)=(1-2*RAT)/(8-6*RAT)
	HB(3)=0.D0


      ELSEIF (METHOD.EQ.7) THEN !BIT 41 (2001) LANG-VERWER
* (STRONGLY A-STABLE 1d, ORDER 3 AS ROW METHOD, STAGE-ORDER Prot-Rob=2) 
	ISTAGE=3 !NUMBER OF STAGES
       IQ=2 !EMBEDDED ROW METHOD OF ORDER TWO (ORDER ONE AS W-METHOD)

      THETA=7.886751345948129D-01


	A(2,1)=1.267949192431123D0*THETA
	A(3,1)=1.267949192431123D0*THETA
	A(3,2)=0.D0

	Q(2,1)=-1.607695154586736D0*THETA
	Q(3,1)=-3.464101615137755D0*THETA
	Q(3,2)=-1.732050807568877D0*THETA

	C(1)=0
	C(2)=1.D0
	C(3)=1.D0

	B(1)=2.D0*THETA
	B(2)=5.773502691896258D-01*THETA
	B(3)=4.226497308103742D-01*THETA

	RO(1)=7.886751345948129D-01/THETA
	RO(2)=-2.113248654051871D-01/THETA
	RO(3)=-1.077350269189626D0/THETA

	HB(1)=2.113248654051871D0*THETA
	HB(2)=1.D0*THETA
	HB(3)=4.226497308103742D-01*THETA

      ELSEIF (METHOD.EQ.8) THEN !ROS3Pw (RANG, BIT 2005, Order 3 as ROW-method)

	ISTAGE=3 !NUMBER OF STAGES 
       IQ=2 !EMBEDDED METHOD IS ORDER 2 FOR THE CASE F'(Y_N)-T= O(TAU)

	 THETA=0.78867513459481287D0

	A(2,1)=1.5773502691896257D0
	A(3,1)=0.5D0
	A(3,2)=0.D0

	Q(2,1)=-2.D0
      Q(3,1)=-1.2834936490538903D0
	Q(3,2)=-0.21650635094610965D0

      B(1)=1.2886751345948128D0
	B(2)=0.23205080756887728D0
	B(3)=0.84529946162074843D0

      HB(1)= 1.5729703622514881D0
	HB(2)= 0.51634603522555264D0
	HB(3)= 0.84529946162074843D0

      C(1)=0.D0
	C(2)=1.5773502691896257D0
	C(3)=0.50000000000000000D0

        RO(1)=1.D0
        RO(2)=-1.D0
        RO(3)=-0.066987298107780624D0

	ELSE IF (METHOD.EQ.10) THEN !method ROW4-ORD3-A (KUTTA), NUMDIFF 2015
* (L-STABLE FOR d=1, A(0)-STABLE ANY d, ORDER 3 AS W-METHOD)

	ISTAGE=4 !NUMBER OF STAGES,   
       IQ=2
	 THETA= 0.4489448003024833D0

      RAT=DSQRT(3.D0)

	A(2,1)=1.D0/2
	A(3,1)=(3-RAT)/4
	A(3,2)=1.D0/2

	A(4,1)=3-RAT/2
	A(4,2)=(3-RAT)/2
	A(4,3)=1.D0

	Q(2,1)=(-3+RAT)/2
	Q(3,1)=(-6+RAT)/2
	Q(3,2)=(-3+RAT)/2

	Q(4,1)=(-9+5*RAT)/2
	Q(4,2)=-6+RAT
	Q(4,3)=-3+RAT

	C(1)=0
	C(2)=1.D0/2
	C(3)=1.D0/2
	C(4)=1

	B(1)=(29-9*RAT)/12.D0
	B(2)=(11-2*RAT)/6
	B(3)=(5-RAT)/6.D0
	B(4)=1/6.D0 

      HB(1)= (3-RAT)*3/4 !EMBEDDED METHOD OF ORDER TWO
      HB(2)= 3.D0/2-1.D0/RAT
      HB(3)= (3-RAT)/6
      HB(4)= 0

	ELSE IF (METHOD.EQ.13) THEN !Explicit method of  KUTTA, embedded method of order two
* (L-STABLE FOR d=1, A(0)-STABLE ANY d, ORDER 3 AS W-METHOD)

	ISTAGE=4 !NUMBER OF STAGES,   
       IQ=2
	 THETA= 0.D0

      RAT=DSQRT(3.D0)

	A(2,1)=1.D0/2
	A(3,1)=(3-RAT)/4
	A(3,2)=1.D0/2

	A(4,1)=3-RAT/2
	A(4,2)=(3-RAT)/2
	A(4,3)=1.D0

	Q(2,1)=(-3+RAT)/2
	Q(3,1)=(-6+RAT)/2
	Q(3,2)=(-3+RAT)/2

	Q(4,1)=(-9+5*RAT)/2
	Q(4,2)=-6+RAT
	Q(4,3)=-3+RAT

	C(1)=0
	C(2)=1.D0/2
	C(3)=1.D0/2
	C(4)=1

	B(1)=(29-9*RAT)/12.D0
	B(2)=(11-2*RAT)/6
	B(3)=(5-RAT)/6.D0
	B(4)=1/6.D0 

      HB(1)= (3-RAT)*3/4 !EMBEDDED METHOD OF ORDER TWO
      HB(2)= 3.D0/2-1.D0/RAT
      HB(3)= (3-RAT)/6
      HB(4)= 0

      ELSEIF (METHOD.EQ.20) THEN !ros1-amf2 (JCAM 262(2014), Theorem.5)

	ISTAGE=2 !NUMBER OF STAGES
       IQ=1

      
	 THETA=0.5d0

	A(2,1)=1.D0/2

	Q(2,1)=-1.d0

	C(1)=0
	C(2)=1.D0/2
	

	B(1)=1.d0
	B(2)=1.d0

	RO(1)=1.D0
	RO(2)=0.D0

	HB(1)= 1.D0
	HB(2)= 0.D0

      ELSEIF (METHOD.EQ.21) THEN !ros1-amf3 (JCAM 262(2014), Theorem.5)

	ISTAGE=3 !NUMBER OF STAGES
        IQ=1

      
	 THETA=0.5d0

	A(2,1)=1.D0/2
	A(3,1)=1.D0/2
	A(3,2)=1.D0/2
 

	Q(2,1)=-1.d0
	Q(3,1)=-1.d0
	Q(3,2)=-1.d0

	C(1)=0
	C(2)=1.D0/2
	C(3)=1.D0/2
	

	B(1)=1.d0
	B(2)=1.d0
	B(3)=1.d0

	RO(1)=1.D0
	RO(2)=0.D0
	RO(3)=0.D0

	HB(1)= 1.D0
	HB(2)= 0.D0
	HB(3)= 0.D0


	ELSE IF (METHOD.EQ.31) THEN !ROS34PRW (J. Rang, JCAM 262(2014) 105-114).
* (L-STABLE FOR d=1, ORDER 3 AS ROW-METHOD, ORDER AS W-METHOD ??)

	ISTAGE=4 !NUMBER OF STAGES,   
       IQ=2
	 THETA=4.3586652150845900D-01

      A(2,1)=0.87173304301691801D0
	A(3,1)=0.83539727658178561D0
	A(3,2)=-0.31840250568090289D0
	A(4,1)=1.6159918825691588D0
	A(4,2)=0.86507344089375034D0
	A(4,3)=-0.31505192016694938D0


      Q(2,1)=-2.D0
	Q(3,1)=-0.63183248491964937D0
	Q(3,2)=1.1587723087048447D0
	
	Q(4,1)=-0.35489648691627891D0
	Q(4,2)=0.95669953477701867D0
	Q(4,3)=-0.39412361802766065D0

	C(1)=0
	C(2)=0.87173304301691801D0
	C(3)=1.1537997822626885
	C(4)=1

      B(1)=1.6159918825691587D0
	B(2)=0.86507344089375029D0
	B(3)=-0.31505192016694936D0
      B(4)=0.43586652150845900D0

      HB(1)=1.6509315649179497D0
	HB(2)=0.79943404422542011D0
	HB(3)=-0.18783402340209331D0
	HB(4)=0.32196803361747034D0

      RO(1)=1.D0
      RO(2)=-1.D0
      RO(3)=-7.906047936244941D-01
      RO(4)=0.D0
      
	ELSE IF (METHOD.EQ.40) THEN !RK3_8 SEVE (BAD EMBEDDED)
* (Strongly A-STABLE FOR d=1, ORDER 3 AS W-METHOD AND ORDER 4 AS ROW-METHOD (even if f'(y_n)-W=O(tau)))
* Embedded method is only order 2 as W method  (and ROW method) 

	ISTAGE=4 !NUMBER OF STAGES,   
       IQ=2
	 THETA=0.5D0

      A(2,1)=1.D0/3
	A(3,1)=1
	A(3,2)=1
	A(4,1)=4.D0/3
	A(4,2)=0
	A(4,3)=1


      Q(2,1)=-4.D0/3
	Q(3,1)=-5.D0/3
	Q(3,2)=-1
	
	Q(4,1)=-3
	Q(4,2)=-3
	Q(4,3)=-6

	C(1)=0
	C(2)=1.D0/3
	C(3)=2.D0/3
	C(4)=1

      B(1)=13.D0/8
	B(2)=9.D0/8
	B(3)=9.D0/8
      B(4)=1.D0/8

      HB(1)= 3.D0/2
	HB(2)= 3.D0/4
	HB(3)= 3.D0/4
	HB(4)= 0

	RO(1)=1.D0
	RO(2)=-1.D0/3
	RO(3)=-1.D0/3
	RO(4)=1.D0

	ELSE IF (METHOD.EQ.41) THEN !RK3_8 SEVE (BAD EMBEDDED)
* (L-STABLE FOR d=1, ORDER 3 AS W-METHOD AND ORDER 4 AS ROW-METHOD (even if f'(y_n)-W=O(tau)))
* Embedded method is only order 2 as W method (and ROW method)

	ISTAGE=4 !NUMBER OF STAGES,   
       IQ=2
	 THETA=0.572816062482134855D0

      A(2,1)=1.D0/3
	A(3,1)=1
	A(3,2)=1
	A(4,1)=4.D0/3
	A(4,2)=0
	A(4,3)=1


      Q(2,1)=-4.D0/3
	Q(3,1)=-5.D0/3
	Q(3,2)=-1
	
	Q(4,1)=-3
	Q(4,2)=-3
	Q(4,3)=-6

	C(1)=0
	C(2)=1.D0/3
	C(3)=2.D0/3
	C(4)=1

      B(1)=13.D0/8
	B(2)=9.D0/8
	B(3)=9.D0/8
      B(4)=1.D0/8

      HB(1)= 3.D0/2
	HB(2)= 3.D0/4
	HB(3)= 3.D0/4
	HB(4)= 0

	RO(1)=1.D0
	RO(2)=-1.D0/3
	RO(3)=-1.D0/3
	RO(4)=1.D0
	ELSE IF (METHOD.EQ.42) THEN !RK3_8 SEVE (BAD EMBEDDED)
* (Strongly A-STABLE FOR d=1, ORDER 3 AS W-METHOD AND ORDER 4 AS ROW-METHOD (even if f'(y_n)-W=O(tau)))
* Embedded method is order 2 as W-method and order 3 as ROW-method  
* (even if f'(y_n)-W=O(tau))) embedded method turns out not very good


	ISTAGE=5 !NUMBER OF STAGES,   
       IQ=3
	 THETA=0.5D0

      A(2,1)=1.D0/3
	A(3,1)=1.D0
	A(3,2)=1.D0

	A(4,1)=4.D0/3
	A(4,2)=0
	A(4,3)=1.D0

	A(5,1)=4.D0/3
	A(5,2)=0
	A(5,3)=1.D0



      Q(2,1)=-4.D0/3
	Q(3,1)=-5.D0/3
	Q(3,2)=-1.D0

	Q(4,1)=-3.D0
	Q(4,2)=-3.D0
	Q(4,3)=-6.D0

	Q(5,1)=-4.D0/3
	Q(5,2)=-2.D0
	Q(5,3)=-5.D0
      Q(5,4)=-1.D0

	C(1)=0
	C(2)=1.D0/3
	C(3)=2.D0/3
	C(4)=1.D0
	C(5)=1.D0

      B(1)=13.D0/8
	B(2)=9.D0/8
	B(3)=9.D0/8
      B(4)=1.D0/8
	B(5)=0.D0


      HB(1)= 17.D0/12
	HB(2)= 1.D0
	HB(3)= 1.D0
	HB(4)= 1.D0/8
	HB(5)= 1.D0/8

	RO(1)=1.D0
	RO(2)=-1.D0/3
	RO(3)=-1.D0/3
	RO(4)=1.D0
	RO(5)=1.D0

	ELSE IF (METHOD.EQ.43) THEN !RK3_8 SEVE (BAD EMBEDDED)
* (L-STABLE FOR d=1, ORDER 3 AS W-METHOD AND ORDER 4 AS ROW-METHOD (even if f'(y_n)-W=O(tau)))
* Embedded method is order 2 as W-method and order 3 as ROW-method  (even if f'(y_n)-W=O(tau))) 

	ISTAGE=5 !NUMBER OF STAGES,   
       IQ=3
	 THETA=0.572816062482134855D0

      A(2,1)=1.D0/3
	A(3,1)=1.D0
	A(3,2)=1.D0

	A(4,1)=4.D0/3
	A(4,2)=0
	A(4,3)=1.D0

	A(5,1)=4.D0/3
	A(5,2)=0
	A(5,3)=1.D0



      Q(2,1)=-4.D0/3
	Q(3,1)=-5.D0/3
	Q(3,2)=-1.D0

	Q(4,1)=-3.D0
	Q(4,2)=-3.D0
	Q(4,3)=-6.D0

	Q(5,1)=-4.D0/3
	Q(5,2)=-2.D0
	Q(5,3)=-5.D0
      Q(5,4)=-1.D0

	C(1)=0
	C(2)=1.D0/3
	C(3)=2.D0/3
	C(4)=1.D0
	C(5)=1.D0

      B(1)=13.D0/8
	B(2)=9.D0/8
	B(3)=9.D0/8
      B(4)=1.D0/8
	B(5)=0.D0


      HB(1)= 17.D0/12
	HB(2)= 1.D0
	HB(3)= 1.D0
	HB(4)= 1.D0/8
	HB(5)= 1.D0/8

	RO(1)=1.D0
	RO(2)=-1.D0/3
	RO(3)=-1.D0/3
	RO(4)=1.D0
	RO(5)=1.D0

	ELSE IF (METHOD.EQ.44) THEN !RK3_8 SEVE  (GOOD EMBEDDED)!!!
* (strongly A-STABLE FOR d=1, ORDER 3 AS W-METHOD AND ORDER 4 AS ROW-METHOD (even if f'(y_n)-W=O(tau)))
* Moreover has order 3 for DAEs of index one.
* Embedded method is order 2 as W-method and order 3 as ROW-method  (even if f'(y_n)-W=O(tau)))


	ISTAGE=5 !NUMBER OF STAGES,   
       IQ=3
	 THETA=0.5D0

      A(2,1)=1.D0/3
	A(3,1)=1.D0
	A(3,2)=1.D0

	A(4,1)=4.D0/3
	A(4,2)=0
	A(4,3)=1.D0

	A(5,1)=4.D0/3
	A(5,2)=0
	A(5,3)=1.D0



      Q(2,1)=-4.D0/3
	Q(3,1)=-5.D0/3
	Q(3,2)=-1.D0

	Q(4,1)=-3.D0
	Q(4,2)=-3.D0
	Q(4,3)=-6.D0

	Q(5,1)=0.D0
	Q(5,2)=0.D0
	Q(5,3)=0.D0
      Q(5,4)=0.D0

	C(1)=0
	C(2)=1.D0/3
	C(3)=2.D0/3
	C(4)=1.D0
	C(5)=1.D0

      B(1)=13.D0/8
	B(2)=9.D0/8
	B(3)=9.D0/8
      B(4)=1.D0/8
	B(5)=0.D0


      HB(1)= 7.D0/5
	HB(2)= 3.D0/4
	HB(3)= 3.D0/5
	HB(4)= 0.D0
	HB(5)= 1.D0/20

	RO(1)=1.D0
	RO(2)=-1.D0/3
	RO(3)=-1.D0/3
	RO(4)=1.D0
	RO(5)=1.D0

	ELSE IF (METHOD.EQ.45) THEN !RK3_8 SEVE  (GOOD EMBEDDED)
* (L-STABLE FOR d=1, ORDER 3 AS W-METHOD AND ORDER 4 AS ROW-METHOD (even if f'(y_n)-W=O(tau)))
* Embedded method is order 2 as W-method and order 3 as ROW-method  (even if f'(y_n)-W=O(tau)))

	ISTAGE=5 !NUMBER OF STAGES,   
       IQ=3
	 THETA=0.572816062482134855D0

      A(2,1)=1.D0/3
	A(3,1)=1.D0
	A(3,2)=1.D0

	A(4,1)=4.D0/3
	A(4,2)=0
	A(4,3)=1.D0

	A(5,1)=4.D0/3
	A(5,2)=0
	A(5,3)=1.D0



      Q(2,1)=-4.D0/3
	Q(3,1)=-5.D0/3
	Q(3,2)=-1.D0

	Q(4,1)=-3.D0
	Q(4,2)=-3.D0
	Q(4,3)=-6.D0

	Q(5,1)=0.D0
	Q(5,2)=0.D0
	Q(5,3)=0.D0
      Q(5,4)=0.D0

	C(1)=0
	C(2)=1.D0/3
	C(3)=2.D0/3
	C(4)=1.D0
	C(5)=1.D0

      B(1)=13.D0/8
	B(2)=9.D0/8
	B(3)=9.D0/8
      B(4)=1.D0/8
	B(5)=0.D0


      HB(1)= 7.D0/5
	HB(2)= 3.D0/4
	HB(3)= 3.D0/5
	HB(4)= 0.D0
	HB(5)= 1.D0/20

	RO(1)=1.D0
	RO(2)=-1.D0/3
	RO(3)=-1.D0/3
	RO(4)=1.D0
	RO(5)=1.D0

	ELSE IF (METHOD.EQ.48) THEN !RK3_8 SEVE  (EMBEDDED METHOD OF ORDER TWO)
* (strongly A-STABLE FOR d=1, ORDER 3 AS W-METHOD AND ORDER 4 AS ROW-METHOD (even if f'(y_n)-W=O(tau)))
* Moreover has order 3 for DAEs of index one.


	ISTAGE=4 !NUMBER OF STAGES,   
         IQ=2
         RAT=DSQRT(3.D0)
	 THETA=(3.D0+RAT)/12

        A(2,1)=1.D0/3

	A(3,1)=1.D0
	A(3,2)=1.D0

	A(4,1)= 2 - RAT/3
	A(4,2)= 2-RAT
	A(4,3)= 1.D0



        Q(2,1)= -4.D0/3
	Q(3,1)=  (-7 + RAT)/3
	Q(3,2)= -3 + RAT

	Q(4,1)= -5 + RAT
	Q(4,2)= -9 + 3*RAT
	Q(4,3)= -6


	C(1)=0
	C(2)=1.D0/3
	C(3)=2.D0/3
	C(4)=1.D0

        B(1)= (17 -2*RAT)/8
	B(2)= 3*(7-2*RAT)/8
	B(3)= 9.D0/8
        B(4)= 1.D0/8

        HB(1)= 2 -RAT/4
	HB(2)= (9.D0-3*RAT)/4
	HB(3)= 3.D0/4
        HB(4)= 0.D0

      
	RO(1)=1.D0
	RO(2)=-1.D0/3
	RO(3)=-1.D0/3
	RO(4)=1.D0




            ELSE IF (METHOD.EQ.50) THEN !method GERISCH-VERWER, APPL. NUM. MATH. 2002
* (L-STABLE FOR d=1, A(0)-STABLE ANY d, ORDER 2 AS W-METHOD)

	ISTAGE=3 !NUMBER OF STAGES,   
       IQ=1

	THETA= 0.4358665215084589994160193D0

  
	A(2,1)=1.D0/2
	A(3,1)=0.1872550262359848944952817D0
	A(3,2)=1.D0/2

	Q(2,1)=0.6254899475280302110094366D0
	Q(3,1)=-0.6136849361662244645397549D0
	Q(3,2)=-1.852859819860479140088975D0

	C(1)=0
	C(2)=1.D0/2
	C(3)=1.D0

	B(1)=0.3293983295460647511767728D0
	B(2)=0.9509532732868263800296582D0
	B(3)=0.3333333333333333333333333D0

	RO(1)=1.D0
	RO(2)=1.625489947528030211009435D0
	RO(3)=-2.625489947528030211009435D0


	HB(2)= 0.5D0 !EMBEDDED METHOD OF ORDER ONE
	HB(1)=1-HB(2)*(1+Q(2,1))
	HB(3)=0



	ELSE IF (METHOD.EQ.60) THEN !method W-METHOD HUNDSDORFER-VERWER,
* Springer (2003), p. 400, b2=1/2
* This is the linearization of the HV2 method used in the article of Karel.
*The method used to compute the exact solution is the non-linear version of this one

	ISTAGE=2 !NUMBER OF STAGES,   
       IQ=1

	THETA=0.5D0 + DSQRT(3.D0)/6  !THETA=1.D0+DSQRT(2.D0)/2.D0 gives worst results

  
	A(2,1)=1.D0

	Q(2,1)= -2.d0
	
	C(1)=0
	C(2)=1.D0

	B(1)=1.5D0
	B(2)=0.5D0

	RO(1)=1.D0
	RO(2)=1+Q(2,1)


	HB(1)= 1.D0 !EMBEDDED METHOD OF ORDER ONE
	HB(2)= 0.D0 !(PROPOSED IN THE BOOK)


	ELSE IF (METHOD.EQ.61) THEN !HUNDSDORFER-VERWER (ORDER 3 AS ROW METHOD)
* Springer (2003), p. 400, b2=3/4 (ORDER 3 WHEN J-W=O(tau)) and 
* L-stable for theta=1/2+ \sqrt(3)/6 
* Embeded method of order 1 (as W-method)
	ISTAGE=2 !NUMBER OF STAGES,   
       IQ=1

	THETA=0.5D0 + DSQRT(3.D0)/6  !THETA=1.D0+DSQRT(2.D0)/2.D0 gives worst results
	MU=THETA
  
	A(2,1)=2.D0/3

	Q(2,1)= -4.d0/3
	
	C(1)=0
	C(2)=2.D0/3

	B(1)=1.25D0
	B(2)=0.75D0

	RO(1)=1.D0
	RO(2)=1+Q(2,1)


	HB(1)= 1.D0 !EMBEDDED METHOD OF ORDER ONE
	HB(2)= 0.D0 !(PROPOSED IN THE BOOK)

      ELSEIF (METHOD.EQ. 70) THEN  !method based on paper (Appl.Math.Comput. 274(2016) 565-584, Theorem 1)
* It is Strongly A-stable method for d=1 (R(\infty)=0.73… It has order 3 has ROW method, 
* order 3 as W-method whenever J W- W J=O(tau). Pseudo stage order q=2 (PR model). This would imply order 3 
* for parabolic problems even for time dependent BCs  

	ISTAGE=3 !NUMBER OF STAGES 
        IQ=2
        RAT=DSQRT(3.D0)
        THETA=0.5D0+RAT/6


	A(2,1)=THETA
	A(3,1)=THETA/2
	A(3,2)=(3+2*RAT)/12

	Q(2,1)=-1.D0
	Q(3,1)=-(4+RAT)/4
	Q(3,2)=-(5+3*RAT)/4


	B(1)= (11-5*RAT)/2
	B(2)=(15-7*RAT)/2
	B(3)=-10+6*RAT

	RO(1)= 1.D0
	RO(2)= 0.D0
	RO(3)= -RAT/4

	C(1)=0.D0
	C(2)=A(2,1)
	C(3)=A(3,1)

	HB(2)= 2-RAT !EMBEDDED METHOD OF ORDER TWO
	HB(1)= 1.D0
	HB(3)= 0

      ELSEIF (METHOD.EQ.80) THEN  !method based on paper (Appl.Math.Comput. 274(2016) 565-584, Theorem 1)
* It is Strongly A-stable method for d=1 (R(\infty)=0.73.. 
* order 3 as W-method whenever J W- W J=O(tau). Pseudo stage order q=2 (PR model). This would imply order 3 
* for parabolic problems even for time dependent BCs (c2=1/2+Sqrt[3]/3. 
* The free parameter c3 was chosen so that the error coefficients (of order four) 
* for the explicit RK method are minimized. c3=(117-5*Sqrt[3])/(156-6*Sqrt[3])

	ISTAGE=3 !NUMBER OF STAGES 
        IQ=2
        THETA=0.788675134594812882D0

      A(2,1)=0.788675134594812882D0
	A(3,1)=0.744052337667559335D0
	A(3,2)=0.115014050010195706D0


      Q(2,1)=-1.D0 
      Q(3,1)=-1.14263073887399759D0
	Q(3,2)=-0.544252328232513830D0

      B(1)=1.26206730127769581D0
	B(2)=-0.0994503461009474115D0
	B(3)= 1.83738304482325160D0

      RO(1)=1.D0
	RO(2)=0.D0
	RO(3)=-0.142630738873997593D0

	C(1)=0.D0
	C(2)=0.788675134594812882D0
	C(3)=0.744052337667559335D0
	
	
	HB(1)=1.D0
	HB(2)=0.267949192431122706D0
	HB(3)=0.D0

      ELSEIF (METHOD.EQ. 81) THEN  
* THE SAME AS METHOD 80 (THERE ARE 2 OPTIONS TO FORM THE W-METHOD)

	ISTAGE=3 !NUMBER OF STAGES 
        IQ=2
        THETA=0.788675134594812882D0

      A(2,1)=0.788675134594812882D0
	A(3,1)=0.0446227969272535471D0
	A(3,2)=0.115014050010195706D0


      Q(2,1)=-1.D0 
      Q(3,1)=-0.255789617529855831D0
	Q(3,2)=-0.544252328232513830D0

      B(1)=-0.367399538532070118D0
	B(2)= 1.53001649370881852D0
	B(3)= 1.83738304482325160D0

      RO(1)=1.D0
	RO(2)=0.D0
	RO(3)=0.744210382470144169D0

	C(1)=0.D0
	C(2)=0.788675134594812882D0
	C(3)=0.744052337667559335D0
	
	
	HB(1)=1.D0
	HB(2)=0.267949192431122706D0
	HB(3)=0.D0

      ELSEIF (METHOD.EQ.90) THEN  !method based on paper (Appl.Math.Comput. 274(2016) 565-584, Theorem 1)
* It is Strongly A-stable method for d=1 (R(\infty)=-0.73.. 
* order 3 as W-method whenever J W- W J=O(tau). Pseudo stage order q=2 (PR model). This would imply order 3 
* for parabolic problems even for time dependent BCs (c2=1/2+Sqrt[3]/3). 
* The free parameter a32 (c3) was chosen to maximize nonlinear positivity (R=0.866..)

	ISTAGE=3 !NUMBER OF STAGES 
        IQ=2
        THETA=0.78867513459481288225D0

      A(2,1)=0.78867513459481288225D0
	A(3,1)=0.61715228496316480748D0
	A(3,2)=0.36669496568225391741D0
 
      Q(2,1)=-1.D0 
      Q(3,1)=-1.4176520527674565737D0
	Q(3,2)=-1.7352192084881513951D0
	
      B(1)=1.2406912341244454527D0
	B(2)=1.1830127018922193234D0
	B(3)=0.57629606398333522388D0

      RO(1)=1.D0
	RO(2)=0.D0
	RO(3)=-0.41765205276745657366D0

	C(1)=0.D0
	C(2)=0.78867513459481288225D0
	C(3)=0.61715228496316480748D0
	
	HB(1)=1.D0
	HB(2)=0.26794919243112270647D0
	HB(3)=0.D0

      ELSEIF (METHOD.EQ.91) THEN  !method based on paper (Appl.Math.Comput. 274(2016) 565-584, Theorem 1)
* It is Strongly A-stable method for d=1 (R(\infty)=0.73.. 
* order 3 as W-method whenever J W- W J=O(tau). Pseudo stage order q=2 (PR model). This would imply order 3 
* for parabolic problems even for time dependent BCs (c2=1/2+Sqrt[3]/3). 
* The free parameter a32 (c3) was chosen to minimize fourth order error coefficients for the W-methods.

	ISTAGE=3 !NUMBER OF STAGES 
        IQ=2
        THETA=0.78867513459481288225D0

      A(2,1)=0.78867513459481288225D0
	A(3,1)=0.75673291099831767692D0
	A(3,2)=0.083733335328180024210D0
 
      Q(2,1)=-1.D0 
      Q(3,1)=-1.1045292744619793664D0
	Q(3,2)=-0.39623039706014988658D0
	
      B(1)=1.2638093271933179456D0
	B(2)=-0.78759348767052300206D0
	B(3)=2.5237841604772050565D0

      RO(1)=1.D0
	RO(2)=0.D0
	RO(3)=-0.10452927446197936643D0

	C(1)=0.D0
	C(2)=0.78867513459481288225D0
	C(3)=0.75673291099831767692D0
	
	HB(1)=1.D0
	HB(2)=0.26794919243112270647D0
	HB(3)=0.D0

      

		ENDIF

      RETURN
	END
********************************
